﻿using System;
using System.Collections.Generic;
using System.Data;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities; 

public partial class ReportReferralBySite : BasePage
{
    private const string GET_REFERRAL_SITES = "usp_EFR_GetReferralStations";
    private const string REPORT_NAME = "ReferralBySiteReport";
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private DataTable dataTable = new DataTable();
    public string ServerReportParameters { get; set; }

    bool batchReport = false;        

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!AccessAllowed())
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }

        Session["batchReport"] = SessionItemFactory.Create(batchReport.ToString());
        Session["EFRBatchPrintOptions"] = SessionItemFactory.Create(Helpers.GetCrsSetting("EFRBatchPrintOptions"));
        Session["EFRIndividualPrintOptions"] = SessionItemFactory.Create(Helpers.GetCrsSetting("EFRIndividualPrintOptions"));

        ClientScript.RegisterStartupScript(this.GetType(), "LoadPrintOptions", "window.onload=loadReportPrintOptions();");            

        if (!IsPostBack)
        {
            try
            {
                // Load the Stations list
                dataTable = SqlProvider.ExecuteSPDataTable(
                    "RegistryConnectionString", GET_REFERRAL_SITES,
                    new object[] { });

                ListBoxStations.DataSource = dataTable;
                ListBoxStations.DataBind();
            }
            catch (Exception ex)
            {
                Logging.WriteLogToFile("Error loading referral site list", ex);
            }
        }
    }

    private bool AccessAllowed()
    {
        return true;
    }
    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "Referral Report by Site";
    }

    public override string AppObjectCode()
    {
        return "EFR_SITE_REFERRAL_REPORT";
    }

    private void SetReportPath()
    {
        ReportViewerReport.ServerReport.ReportPath = REPORT_NAME;

        var config = RegistriesConfigurations.GetConfig();

        ReportViewerReport.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

        if (ReportViewerReport.ServerReport.ReportPath.IndexOf(
                Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        {
            ReportViewerReport.ServerReport.ReportPath =
                Helpers.GetConfigEntry("BaseReportPath") + ReportViewerReport.ServerReport.ReportPath;
        }
    }

    protected void ButtonRunReportClick(object sender, EventArgs e)
    {
        ReportViewerReport.Reset();
        SetReportPath();
        SetReportParameters();

        ReportViewerReport.ProcessingMode = ProcessingMode.Remote;
        ReportViewerReport.Visible = true;
        ReportViewerReport.ServerReport.Refresh();
    }

    protected void SetReportParameters()
    {
        var selectedStationsIndices = ListBoxStations.GetSelectedIndices();
        var selectedStations = new List<string>();

        ReportParameter reportParamStations = new ReportParameter("StationID", (ListBoxStations.SelectedValue == "" ? "0" : ListBoxStations.SelectedValue));
        ReportParameter reportParamStationName = new ReportParameter("StationName", (ListBoxStations.SelectedItem == null ? "all stations" : ListBoxStations.SelectedItem.Text));
        
        _reportParameters.Add(reportParamStations);
        _reportParameters.Add(reportParamStationName);
        ReportViewerReport.ServerReport.SetParameters(_reportParameters);

        //Test Stations: 
        //ReportParameter reportParamStations = new ReportParameter("StationID", "V23");
        //_reportParameters.Add(reportParamStations);

        ServerReportParameters += Environment.NewLine + " Station's Selected: " + String.Join(", ", selectedStations.ToArray());

    }
   
}
